/*----------------------------------------------------------------------------
 * Name:    BLE_lib.h
 * Purpose: BLE definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef _HT32_BLE_LIB_H_
#define _HT32_BLE_LIB_H_

#include "ht32.h"

#define BLE_BAUDRATE_9600 	9600
#define BLE_BAUDRATE_115200	115200

//BLE use UART1 and BFTM1
extern void UART_IRQHandler(void);//UART1
extern void BFTM_IRQHandler(void);//BFTM1
/*---------------------------------------------------------------------------- */

/* BLE operation mode define */
#define	OP_NORMAL				0
#define	OP_DEEPSLEEP			1
#define	OP_POWERDOWN			2


/* BLE type */
#define	BLE_STATUS				0x0000		/* get BLE status */
#define	BLE_DISCONNECT			0x0002		/* disconnect current link */
#define	BLE_CONN_INTV			0x0003      /* modify connection interval */
#define	BLE_CONN_INTV1			0x0004      /* modify connection interval */
#define	BLE_DEV_NAME			0x0005      /* setup BLE device name */
#define	BLE_DEV_ADDRESS		    0x0006      /* setup BLE device address */
#define	BLE_ADV_CTRL			0x0007      /* enable/disable BLE Adv */
#define	BLE_ADV_INTV			0x0008      /* setup Adv interval */
#define	BLE_ADV_DATA			0x0009      /* setup Adv data */
#define	BLE_SCAN_DATA			0x000A      /* setup scan data */
#define	BLE_TX_POWER			0x000B      /* setup TX power */
#define	BLE_CLOAD_SET			0x000E      /* setup crystal C-Load */
#define	BLE_PEER_DEV_ADDR		0x000F      /* get peer device address of connect */
#define	BLE_FEATURE_CTRL		0x0010
#define	BLE_VERSION				0x0020      /* get BLE F/W version */
#define	BLE_OPERATE_MODE		0x0025      /* set BLE operate mode mode */
#define	BLE_BAUDRATE			0x0026      /* setup BLE UART interface speed */
#define	BLE_BAUDRATE_MAX		0x0027      /* setup BLE UART interface speed to MAX*/
#define	BLE_SOFT_RESET			0x0028      /* BLE software reset */
#define	BLE_WHITE_LIST			0x002A      /* setup BLE white list */


/* status package define */
typedef union
{
	u32	u;
	struct
	{
		u32	Connect:1;							//b0
		u32	PramUpdateOk:1;               //b1
		u32	PramUpdataFail:1;             //b2
		u32	PramUpdataPeer:1;             //b3
		u32	CalibDone:1;		            //b4
		u32 	:3;                           //b5~b7
		u32	Ext32k:1;                     //b8
		u32	:23;                          //b9~b31
	}b;
}tSTATUS;

/* device address package define */
typedef struct __attribute__((packed))
{
	u8		addr[6];
	u8		type;
}tDEV_ADDR;

/* connect interval package define */
typedef struct __attribute__((packed))
{
	u16	min;
	u16	max;
	u16	latency;
	u16	timeout;
}tCNNT_INTV;

/* Advertising interval package define */
typedef struct __attribute__((packed))
{
	u16	min;
	u16	max;
	u8	map;
}tADV_INTV;



typedef enum
{
	FEATURE_NO_APPED_NAME =	(1UL << 2),
	FEATURE_PARAM_UPDATE	 =	(1UL << 4),
	FEATURE_PARAM_ERASE	 =	(1UL << 5),
	FEATURE_STATUS_EVENT	 =	(1UL << 7),
	FEATURE_CALIB_DONE	 =	(1UL << 9),
	FEATURE_EXTERNAL32K	 =	(1UL << 12),
	FEATURE_FORCE_CALIB	 =	(1UL << 25),
	FEATURE_CK32K_OUTPUT	 =	(1UL << 28),
} FeatureFlag;

typedef union
{
	u32	u;
	struct
	{
		u32	:1;						//b0
		u32	FFF0Parse:1;         //b1
		u32	AppendName:1;        //b2
		u32	:1;                  //b3
		u32	ParaUpdate:1;        //b4
		u32	ParaErase:1;         //b5
		u32	:1;                  //b6
		u32	SatusEvent:1;        //b7
		u32	:1;                  //b8
		u32	CalibDone:1;		   //b9
		u32 	:2;                  //b10~b11
		u32	External32k:1;       //b12
		u32 	:12;		            //b13~b24
		u32	ForceCalib:1;		   //b25
		u32	:2;                  //b26~b27
		u32	CK32Out:3;		      //b28~b30
		u32	:1;		            //b31
	}b;
}tFEATURE;

/* White list package define */
typedef struct __attribute__((packed))
{
	u8		addr[6];
	u8		mask[6];
}tWHITE_LIST;

enum
{
   BAUD_RATE_9600 = 0,
   BAUD_RATE_14400 = 1,
   BAUD_RATE_19200 = 2,
   BAUD_RATE_38400 = 3,
   BAUD_RATE_57600 = 4,
   BAUD_RATE_115200 = 5,
};

typedef enum
{
	BLE_ST_SUCCESS = 0,
	BLE_ST_FAIL,
	BLE_ST_UNKNOWN,
	BLE_ST_NOT_SUPPORT,
	BLE_ST_PENDING,
	BLE_ST_INVALID,
	BLE_ST_NOT_ENABLE = 6,
	BLE_ST_FIFO_FULL = 7,
	BLE_ST__TIME_OUT = 0xE
} en_BLE_St;

#define	BLE_ServiceMessage					0x00
#define	BLE_ServiceSupported				0x10
#define	BLE_ServiceProperties				0x20
#define	BLE_ServiceCmdMask					0xF0

/* GAP Service */
#define	GenericAccess							0x1800
#define 	GenericAttribute						0x1801
#define 	Appearance       						0x2A01
#define 	PeripheralPrivacyFlag					0x2A02
/* Device Information Service */
#define	DeviceInformation             	0x180A
#define 	DevInf_SystemID              		0x2A23
#define 	ModelNumberString           		0x2A24
#define 	SerialNumberString          		0x2A25
#define 	FirmwareRevisionString      		0x2A26
#define 	HardwareRevisionString      		0x2A27
#define 	SoftwareRevisionString      		0x2A28
#define 	ManufacturerNameString      		0x2A29
#define 	IEEE11073_20601RegulatoryCertificationDataList	0x2A2A
#define 	DevInf_PnPID              			0x2A50
/* Batter Service */
#define 	Battery                  			0x180F
#define 	BatteryLevel							0x2A19
/* Blood Service */
#define 	BloodPressure							0x1810
#define 	BloodMeasurement						0x2A35
#define 	BloodFeature							0x2A49
/* Weight Scale Service */
#define 	WeightScale								0x181D
#define 	WeightMeasurement						0x2A9D
#define 	WeightFeature							0x2A9E
/* Unknow Service */
#define	UnknowService							0xFFF0
#define 	NotifyFFF1								0xFFF1
#define 	WithoutResponseFFF2					0xFFF2

typedef void (*FUNPTR_EvtCallback)(u16 type, en_BLE_St evt_status, u8 *buffer, u8 buffer_Len);

#define _CMD_TIMEOUT_ 20 //20*.1.25ms

void BLE_registerEvtCallback(FUNPTR_EvtCallback funptr);

void BLE_InterfaceConfigure(u32 buadrate);
en_BLE_St BLE_Init(void);
void BLE_Routine(void);
en_BLE_St BLE_ReadStatus(void);
en_BLE_St BLE_Disconnect(void);
en_BLE_St BLE_SetConnectInterval(u16 min,u16 max);
en_BLE_St BLE_GetConnectInterval(void);
en_BLE_St BLE_SetDeviceName(u8 *name, u8 length);
en_BLE_St BLE_GetDeviceName(void);
en_BLE_St BLE_SetDeviceAddress(u8 *addr,u8 type);
en_BLE_St BLE_GetDeviceAddress(void);
en_BLE_St BLE_SetAdvertising(ControlStatus ctrl);
en_BLE_St BLE_GetAdvertisingStatus(void);
en_BLE_St BLE_SetAdvertisingInterval(u16 min,u16 max);
en_BLE_St BLE_GetAdvertisingInterval(void);
en_BLE_St BLE_SetAdvertisingData(u8 *advdata,u8 length);
en_BLE_St BLE_GetAdvertisingData(void);
en_BLE_St BLE_SetScanResponseData(u8 *scandata,u8 length);
en_BLE_St BLE_GetScanResponseData(void);
en_BLE_St BLE_SetTxPower(u8 pwr);
en_BLE_St BLE_GetTxPower(void);
en_BLE_St BLE_SetCrystalCload(u8 cl);
en_BLE_St BLE_GetPeerBTAddr(void);
en_BLE_St BLE_SetFeature(FeatureFlag flag);
en_BLE_St BLE_GetVersion(void);
en_BLE_St BLE_SetPowerSaving(u8 mode);
en_BLE_St BLE_SetPowerSavingSlaveWakeup(u8 mode,ControlStatus enableWakeup,u8 wakupEvtDelayTime,u8 wakupByteCnt);
en_BLE_St BLE_DummyWakeup(u8 wakeupByteCnt);
en_BLE_St BLE_SetBaudRate(u32 baudrate);
en_BLE_St BLE_GetBaudRate(void);
en_BLE_St BLE_GetMaxBaudRate(void);
en_BLE_St BLE_SoftwareReset(void);
en_BLE_St BLE_SetWhiteList(ControlStatus eraseBeforeSet,u8 *addr,u8 *mask);
en_BLE_St BLE_GetWhiteList(void);
en_BLE_St BLE_SetCharacteristicValue(u16 Characteristic,u8 serviceFlag,u8 *buffer,u8 length);
en_BLE_St BLE_GetUUIDValue(u16 UUID);

#endif
